* Estimates and SEs of HILDA mobility - by sex and 5 year age groups

set more off
pause off

local workdir  H:\Documents\HILDA Project\Data\HILDA Working\Release 16\residential mobility
local logdir   H:\Documents\HILDA Project\ARC Methodology\UQ research\Chapter 3 - Mobility\Results

capture log close
log using "`logdir'\log_estimates_and_SEs.log", replace

use "`workdir'/move_long", clear
*pause on

* use revised longitudinal weights (which include people turning 15 for responding persons and new births for enuemrated persons)
replace lnwtrp=lnwtrpr
replace lnwte=lnwter
forvalues i=1/45 {
  replace rwlnr`i'=rwlnrr`i'
  replace rwlne`i'=rwlner`i'
}  

* Set up weights that are equal for all enum persons and responding persons, to enable use of svy commands (otherwise mean command will 
* drop categories if missing whereas svy mean wont)
replace lnwtrp=. if lnwtrp==-10
bys wave: egen eqwte =mean(lnwte)  if hhsm==1 & topup==0 & lnwte >0 & lnwte!=. 
bys wave: egen eqwtrp=mean(lnwtrp) if hhsm==1 & topup==0 & lnwtrp>0 & lnwtrp!=.

***********************************
* Summary of mobility probabilities
***********************************
capture program drop propmove
program define propmove
args move wt repwt

local workdir  H:\Documents\HILDA Project\Data\HILDA Working\Release 16\residential mobility
*local workdir  E:\working research\residential mobility
local maxwave  16

* work out which wave to start the series (depends on the name of the move variable - ie whether move in last 12 months, 5 years or 10 years)
* also identify number of years for use in column names
if "`move'"=="hhmove5" | "`move'"=="pmove5" | "`move'"=="move12m5" {
  local minwave 6
  local l 5
}
else if "`move'"=="hhmove10" | "`move'"=="pmove10" | "`move'"=="move12m10" {
  local minwave 11
  local l 10
}
else {
  local minwave 2
  local l 1
}
* identify variable type (h=hhmove, p=pmove, r=respondent move12m)
if "`move'"=="hhmove" | "`move'"=="hhmove5" | "`move'"=="hhmove10" {
  local t h
}
else if "`move'"=="pmove" | "`move'"=="pmove5" | "`move'"=="pmove10" {
  local t p
}
else if "`move'"=="move12m" | "`move'"=="move12m5" | "`move'"=="move12m10" {
  local t r
}
if "`wt'"=="eqwte" {
  local w ue
}
else if "`wt'"=="eqwtrp"  {
  local w ur
}
else if "`wt'"=="lnwte"  {
  local w we
}
else if "`wt'"=="lnwtrp"  {
  local w wr
}
else {
  local w w
}

* Set up survey design
if "`wt'"=="eqwte" | "`wt'"=="eqwtrp" {
  svyset [pweight=`wt']
}
else {
  *svyset [pweight=`wt'], strata(xhhstrat) psu(xhhraid)
  svyset [pweight=`wt'], vce(jackknife) jkrweight(`repwt'*)
}

* Proportion of OSMs that are responding each waves move house each wave (by sex or immig and 5 year age groups, unweighted)
capture matrix drop mmove
capture matrix drop fmove
capture matrix drop pmove
matrix mmove=J(18,15,.)
matrix rownames mmove = 0_4 5_9 10_14 15_19 20_24 25_29 30_34 35_39 40_44 45_49 50_54 ///
	55_59 60_64 65_69 70_74 75_79 80_84 85_100
matrix fmove=mmove
matrix pmove=mmove
matrix colnames mmove = `t'`l'`w'mw2 `t'`l'`w'mw3 `t'`l'`w'mw4 `t'`l'`w'mw5 `t'`l'`w'mw6 `t'`l'`w'mw7 `t'`l'`w'mw8 `t'`l'`w'mw9 `t'`l'`w'mw10 `t'`l'`w'mw11 `t'`l'`w'mw12 `t'`l'`w'mw13 `t'`l'`w'mw14 `t'`l'`w'mw15 `t'`l'`w'mw16
matrix colnames fmove = `t'`l'`w'fw2 `t'`l'`w'fw3 `t'`l'`w'fw4 `t'`l'`w'fw5 `t'`l'`w'fw6 `t'`l'`w'fw7 `t'`l'`w'fw8 `t'`l'`w'fw9 `t'`l'`w'fw10 `t'`l'`w'fw11 `t'`l'`w'fw12 `t'`l'`w'fw13 `t'`l'`w'fw14 `t'`l'`w'fw15 `t'`l'`w'fw16
matrix colnames pmove = `t'`l'`w'pw2 `t'`l'`w'pw3 `t'`l'`w'pw4 `t'`l'`w'pw5 `t'`l'`w'pw6 `t'`l'`w'pw7 `t'`l'`w'pw8 `t'`l'`w'pw9 `t'`l'`w'pw10 `t'`l'`w'pw11 `t'`l'`w'pw12 `t'`l'`w'pw13 `t'`l'`w'pw14 `t'`l'`w'pw15 `t'`l'`w'pw16
matrix mmovese=mmove
matrix fmovese=fmove
matrix pmovese=pmove
* estimates by sex
display in red "Proportion moved (`move'), by age and sex, weighted by `wt'"
forvalues wave=`minwave' / `maxwave' {
  /*quietly*/ svy: mean `move' if wave==`wave' & hhsm==1 & topup==0 & `wt'>0 & `wt'!=., over(ageg sex)
  matrix means=e(b)
  matrix var=e(V)
  local rownum=0
  forvalues i=1 / 18 {
    quietly count if wave==`wave' & hhsm==1 & topup==0 & `wt'>0 & `wt'!=. & sex==1 & ageg==`i' & `move' != .
    local m=r(N)
    quietly count if wave==`wave' & hhsm==1 & topup==0 & `wt'>0 & `wt'!=. & sex==2 & ageg==`i' & `move' != .
	local f=r(N)
	if "`m'" != "0" {
	  local rownum=`rownum'+1
      matrix mmove[`i',`wave'-1]=means[1,`rownum']
      matrix mmovese[`i',`wave'-1]=sqrt(var[`rownum',`rownum'])
  	}  
	if "`f'" != "0" {
	  local rownum=`rownum'+1
      matrix fmove[`i',`wave'-1]=means[1,`rownum']
      matrix fmovese[`i',`wave'-1]=sqrt(var[`rownum',`rownum'])
	}  
  }	
}
display in red "Proportion moved (`move'), weighted by `wt'"
matlist mmove
matlist fmove
display in red "Proportion moved (`move'), weighted by `wt', number contributing to cells"
bys sex: tab ageg wave if wave>=2 & hhsm==1 & topup==0 & `wt'>0 & `move'!=.
pause 
* estimates for all persons
display in red "Proportion moved (`move'), by age, weighted by `wt'"
forvalues wave=`minwave' / `maxwave' {
  /*quietly*/ svy: mean `move' if wave==`wave' & hhsm==1 & topup==0 & `wt'>0 & `wt'!=., over(ageg)
  matrix means=e(b)
  matrix var=e(V)
  local rownum=0
  forvalues i=1 / 18 {
    quietly count if wave==`wave' & hhsm==1 & topup==0 & `wt'>0 & `wt'!=. & ageg==`i' & `move' != .
	local p=r(N)
	if "`p'" != "0" {
	  local rownum=`rownum'+1
      matrix pmove[`i',`wave'-1]=means[1,`rownum']
      matrix pmovese[`i',`wave'-1]=sqrt(var[`rownum',`rownum'])
	}  
  }	
}
display in red "Proportion moved (`move'), weighted by `wt'"
matlist pmove
display in red "Proportion moved (`move'), weighted by `wt', number contributing to cells"
tab ageg wave if wave>=2 & hhsm==1 & topup==0 & `wt'>0 & `move'!=.
pause 
* Save proportion who move
preserve
display in red "saving sex by age estimates"
if "`move'"=="hhmove" & ("`wt'"=="eqwte" | "`wt'"=="eqwtrp") & "`minwave'"=="2" {
clear
svmat mmove, names(col)
svmat fmove, names(col)
svmat pmove, names(col)
save "`workdir'\estimates", replace
}
else {
use "`workdir'\estimates", clear
svmat mmove, names(col)
svmat fmove, names(col)
svmat pmove, names(col)
save "`workdir'\estimates", replace
}
restore
* Save SEs of proportion who move
preserve
display in red "saving sex by age SEs"
if "`move'"=="hhmove" & ("`wt'"=="eqwte" | "`wt'"=="eqwtrp") & "`minwave'"=="2" {
clear
svmat mmovese, names(col)
svmat fmovese, names(col)
svmat pmovese, names(col)
save "`workdir'\sesforestimates", replace
}
else {
use "`workdir'\sesforestimates", clear
svmat mmovese, names(col)
svmat fmovese, names(col)
svmat pmovese, names(col)
save "`workdir'\sesforestimates", replace
}
restore
end

* proportion move (HH and person level variables) - equal weight
propmove hhmove   eqwte
propmove hhmove5  eqwte
propmove hhmove10 eqwte
propmove pmove    eqwte
propmove pmove5   eqwte
propmove pmove10  eqwte

propmove hhmove   eqwtrp
propmove hhmove5  eqwtrp
propmove hhmove10 eqwtrp
propmove pmove    eqwtrp
propmove pmove5   eqwtrp
propmove pmove10  eqwtrp

* proportion move (HH and person level variables) - longitudinal enumerated person weight
propmove hhmove   lnwte rwlne
propmove hhmove5  lnwte rwlne
propmove hhmove10 lnwte rwlne
propmove pmove    lnwte rwlne
propmove pmove5   lnwte rwlne
propmove pmove10  lnwte rwlne

propmove hhmove   lnwtrp rwlnr
propmove hhmove5  lnwtrp rwlnr
propmove hhmove10 lnwtrp rwlnr
propmove pmove    lnwtrp rwlnr
propmove pmove5   lnwtrp rwlnr
propmove pmove10  lnwtrp rwlnr

* proportion move (responding person variables) - equal weight
propmove move12m   eqwtrp
propmove move12m5  eqwtrp
propmove move12m10 eqwtrp

* proportion move (responding person variables) - longitudinal responding person weight
propmove move12m   lnwtrp rwlnr
propmove move12m5  lnwtrp rwlnr
propmove move12m10 lnwtrp rwlnr


log close
